<!DOCTYPE html>
<html lang="zxx">
<head>
    <meta name="title" Content="{{__($basic->sitename)}}">
    <meta name="author" content="{{url('/')}}" />
    <meta property="og:image:type" content="image/jpeg" />
    <meta property="og:image:width" content="590" />
    <meta property="og:image:height" content="300" />


    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title> @isset($page_title)  {{__($page_title)}} | @endisset  {{__($basic->sitename)}}  </title>
    <!-- favicon -->
    <link rel="shortcut icon" href="{{asset('assets/images/logo/favicon.png')}}" type="image/x-icon">

    <!-- bootstrap -->
    <link rel="stylesheet" href=" {{ asset('assets/front/css/bootstrap.min.css')}} ">
    <!-- fontawesome icon  -->
    <link rel="stylesheet" href=" {{ asset('assets/front/css/fontawesome.min.css')}} ">
    <!-- animate.css -->
    <link rel="stylesheet" href=" {{ asset('assets/front/css/animate.css')}} ">
    <!-- Owl Carousel -->
    <link rel="stylesheet" href=" {{ asset('assets/front/css/owl.carousel.min.css') }} ">
    <!-- magnific popup -->
    <link rel="stylesheet" href=" {{ asset('assets/front/css/magnific-popup.css') }} ">
    <!-- slick css -->
    <link rel="stylesheet" href=" {{ asset('assets/front/css/slick.min.css') }} ">
    <!-- stylesheet -->
    <link href="{{asset('assets/admin/css/toastr.min.css')}}" rel="stylesheet" />
<!-- <link rel="stylesheet" href=" {{ asset('assets/front/css/style.css') }} "> -->
    <link rel="stylesheet" href=" {{ asset('assets/front/css/style.php?')}}color={{$basic->color}}&color2={{$basic->color2}}">
    <!-- responsive -->
    <link rel="stylesheet" href=" {{ asset('assets/front/css/responsive.css') }} ">
    <!-- jquery -->
    <script src=" {{ asset('assets/front/js/jquery-3.3.1.min.js') }} "></script>

    <link rel="stylesheet" href="{{ asset('assets/admin/css/sweetalert.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/admin/css/toastr.min.css') }}">
    <link rel="stylesheet" type="text/css" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">
    @yield('style')

</head>

<body>
{!! $basic->fb_comment !!}
<!-- preloader begin-->
<div class="preloader">
    <div class="loader">
        <hr>
        <hr>
    </div>
</div>
<!-- preloader end -->

<!-- header begin-->
<header class="header" style="background-color:cadetblue">
    <div class="container" >
        <div class="row">
            <div class="col-xl-2 col-lg-2 d-xl-flex d-lg-flex align-items-center">
                <div class="row">
                    <div class="col-6 col-xl-12 col-lg-12 d-flex d-xl-block d-lg-block align-items-center">
                        <div class="logo">
                            <a href="{{url('/')}}">
                                <img src=" {{ asset('assets/images/logo/logo.png') }} " alt="{{$basic->sitename}}">
                            </a>
                        </div>
                    </div>
                    <div class="col-6 d-block d-xl-none d-lg-none">
                        <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarNav" aria-controls="navbarNav"
                                aria-expanded="false" aria-label="Toggle navigation">
                            <i class="fas fa-bars"></i>
                        </button>
                    </div>
                </div>

            </div>
            <div class="col-xl-10 col-lg-10" >
                <div class="mainmenu">
                    <nav class="navbar navbar-expand-lg justify-content-center">
                        <div class="collapse navbar-collapse" id="navbarNav">
                            <ul class="navbar-nav nav justify-content-center">


                                    <li class="nav-item">
                                        <a class="nav-link" href="{{route('homepage')}}">@lang('Home')</a>
                                    </li>
                                    <li class="nav-item"><a class="nav-link" href="{{route('blog')}}">@lang('Blog') </a></li>
                                    <li class="nav-item"><a class="nav-link" href="{{route('about')}}">@lang('About Us') </a></li>
                                    <li class="nav-item"><a class="nav-link" href="{{route('faqs')}}">@lang('Faqs') </a></li>

                                    <li class="nav-item"><a class="nav-link" href="{{route('contact')}}">@lang('Contact') </a></li>


                                <li class="nav-item dropdown">
                                    <a class="nav-link dropdown-toggle" href="#" id="05" data-toggle="dropdown"
                                       aria-haspopup="true" aria-expanded="false">
                                        @lang('Language')
                                    </a>
                                    <div class="dropdown-menu" aria-labelledby="05">
                                        <a class="dropdown-item" href="{{route('lang', 'en') }}">@lang('English') </a>
                                        @foreach($lan as $data)
                                            <a class="dropdown-item" href="{{route('lang',$data->code)}}">{{__($data->name)}}</a>
                                        @endforeach
                                    </div>
                                </li>

                                @guest
                                    <li class="nav-item dropdown">
                                        <a class="nav-link dropdown-toggle" href="#" id="05" data-toggle="dropdown"
                                           aria-haspopup="true" aria-expanded="false">
                                            @lang('Account')
                                        </a>
                                        <div class="dropdown-menu" aria-labelledby="05">
                                            <a class="dropdown-item" href="{{route('login')}}">@lang('Sign In') </a>
                                            <a class="dropdown-item" href="{{route('register')}}">@lang('Sign Up') </a>
                                        </div>
                                    </li>
                                @endguest

                                @auth
                                    <li class="nav-item dropdown">
                                        <a class="nav-link dropdown-toggle" href="#" id="05" data-toggle="dropdown"
                                           aria-haspopup="true" aria-expanded="false">
                                            @lang('Bal:') {{number_format(Auth::user()->balance, $basic->decimal)}} {{$basic->currency}}
                                        </a>
                                        <div class="dropdown-menu" aria-labelledby="05">

                                            <a class="dropdown-item" href="{{route('home')}}">@lang('My Exchanges') </a>
                                            <a class="dropdown-item" href="{{route('edit-profile')}}">@lang('My Profile')</a>
                                            <a class="dropdown-item" href="{{route('user.change-password')}}">@lang('Change Password')</a>
                                            <a href="{{ route('logout') }}" class="dropdown-item"
                                               onclick="event.preventDefault(); document.getElementById('logout-form').submit();">@lang('Sign Out')</a>
                                            <form id="logout-form" action="{{ route('logout') }}" method="POST"
                                                  style="display: none;">{{ csrf_field() }}</form>
                                        </div>
                                    </li>
                                @endauth






                            </ul>
                        </div>
                    </nav>
                </div>
            </div>
        </div>
    </div>
</header>
<!-- header end -->

@yield('content')
@include('partials.footer')

@yield('js')

{!! $basic->tawkto !!}

@if (Session::has('success'))
    <script type="text/javascript">
        $(document).ready(function () {
            swal("{{ __(Session::get('success')) }}","", "success");
        });
    </script>
@endif

@if (Session::has('warning'))
    <script type="text/javascript">
        $(document).ready(function () {
            swal("{{ __(Session::get('warning')) }}","", "warning");
        });
    </script>
@endif

@if(Session::has('message'))
<script type="text/javascript">
    var type = "{{Session::get('alert-type','info')}}";
    switch (type) {
        case 'info':
            toastr.info("{{Session::get('message')}}");
            break;
        case 'warning':
            toastr.warning("{{Session::get('message')}}");
            break;
        case 'success':
            toastr.success("{{Session::get('message')}}");
            break;
        case 'error':
            toastr.error("{{Session::get('message')}}");
            break;
    }
</script>
@endif


</body>

</html>
